/*
  ==============================================================================

  This is an automatically generated GUI class created by the Introjucer!

  Be careful when adding custom code to these files, as only the code within
  the "//[xyz]" and "//[/xyz]" sections will be retained when the file is loaded
  and re-saved.

  Created with Introjucer version: 3.1.0

  ------------------------------------------------------------------------------

  The Introjucer is part of the JUCE library - "Jules' Utility Class Extensions"
  Copyright 2004-13 by Raw Material Software Ltd.

  ==============================================================================
*/

//[Headers] You can add your own extra header files here...
//[/Headers]

#include "EXCOSCSettingsComponent.h"


//[MiscUserDefs] You can add your own user definitions and misc code here...
//[/MiscUserDefs]

//==============================================================================
EXCOSCSettingsComponent::EXCOSCSettingsComponent ()
{
    addAndMakeVisible (listenPortLabel = new Label ("listenPortLabel",
                                                    "Listen Port:"));
    listenPortLabel->setFont (Font (15.00f, Font::plain));
    listenPortLabel->setJustificationType (Justification::centredLeft);
    listenPortLabel->setEditable (false, false, false);
    listenPortLabel->setColour (TextEditor::textColourId, Colours::black);
    listenPortLabel->setColour (TextEditor::backgroundColourId, Colour (0x00000000));

    addAndMakeVisible (listenPortEditor = new TextEditor ("listenPortEditor"));
    listenPortEditor->setMultiLine (false);
    listenPortEditor->setReturnKeyStartsNewLine (false);
    listenPortEditor->setReadOnly (false);
    listenPortEditor->setScrollbarsShown (true);
    listenPortEditor->setCaretVisible (true);
    listenPortEditor->setPopupMenuEnabled (true);
    listenPortEditor->setText ("5678");

    addAndMakeVisible (sendAddressLabel = new Label ("sendAddressLabel",
                                                     "Send Address:"));
    sendAddressLabel->setFont (Font (15.00f, Font::plain));
    sendAddressLabel->setJustificationType (Justification::centredLeft);
    sendAddressLabel->setEditable (false, false, false);
    sendAddressLabel->setColour (TextEditor::textColourId, Colours::black);
    sendAddressLabel->setColour (TextEditor::backgroundColourId, Colour (0x00000000));

    addAndMakeVisible (sendAddressEditor = new TextEditor ("sendAddressEditor"));
    sendAddressEditor->setMultiLine (false);
    sendAddressEditor->setReturnKeyStartsNewLine (false);
    sendAddressEditor->setReadOnly (false);
    sendAddressEditor->setScrollbarsShown (true);
    sendAddressEditor->setCaretVisible (true);
    sendAddressEditor->setPopupMenuEnabled (true);
    sendAddressEditor->setText ("127.0.0.1");

    addAndMakeVisible (sendPortLabel = new Label ("sendPortLabel",
                                                  "Send Port:"));
    sendPortLabel->setFont (Font (15.00f, Font::plain));
    sendPortLabel->setJustificationType (Justification::centredLeft);
    sendPortLabel->setEditable (false, false, false);
    sendPortLabel->setColour (TextEditor::textColourId, Colours::black);
    sendPortLabel->setColour (TextEditor::backgroundColourId, Colour (0x00000000));

    addAndMakeVisible (sendPortEditor = new TextEditor ("sendPortEditor"));
    sendPortEditor->setMultiLine (false);
    sendPortEditor->setReturnKeyStartsNewLine (false);
    sendPortEditor->setReadOnly (false);
    sendPortEditor->setScrollbarsShown (true);
    sendPortEditor->setCaretVisible (true);
    sendPortEditor->setPopupMenuEnabled (true);
    sendPortEditor->setText ("10001");

    addAndMakeVisible (addToPatcherButton = new ToggleButton ("addToPatcherButton"));
    addToPatcherButton->setButtonText ("Add ports to Patcher");
    addToPatcherButton->addListener (this);


    //[UserPreSize]

	listenPortEditor->addListener(this);
	sendAddressEditor->addListener(this);
	sendPortEditor->addListener(this);

    //[/UserPreSize]

    setSize (600, 400);


    //[Constructor] You can add your own custom stuff here..
    //[/Constructor]
}

EXCOSCSettingsComponent::~EXCOSCSettingsComponent()
{
    //[Destructor_pre]. You can add your own custom destruction code here..
    //[/Destructor_pre]

    listenPortLabel = nullptr;
    listenPortEditor = nullptr;
    sendAddressLabel = nullptr;
    sendAddressEditor = nullptr;
    sendPortLabel = nullptr;
    sendPortEditor = nullptr;
    addToPatcherButton = nullptr;


    //[Destructor]. You can add your own custom destruction code here..
    //[/Destructor]
}

//==============================================================================
void EXCOSCSettingsComponent::paint (Graphics& g)
{
    //[UserPrePaint] Add your own custom painting code here..
    //[/UserPrePaint]

    g.fillAll (Colour (0xffeeece1));

    //[UserPaint] Add your own custom painting code here..
    //[/UserPaint]
}

void EXCOSCSettingsComponent::resized()
{
    listenPortLabel->setBounds (8, 8, 88, 24);
    listenPortEditor->setBounds (96, 8, 56, 24);
    sendAddressLabel->setBounds (8, 40, 104, 24);
    sendAddressEditor->setBounds (112, 40, 96, 24);
    sendPortLabel->setBounds (216, 40, 80, 24);
    sendPortEditor->setBounds (296, 40, 56, 24);
    addToPatcherButton->setBounds (getWidth() - 167, 8, 159, 24);
    //[UserResized] Add your own custom resize handling here..
    //[/UserResized]
}

void EXCOSCSettingsComponent::buttonClicked (Button* buttonThatWasClicked)
{
    //[UserbuttonClicked_Pre]
    //[/UserbuttonClicked_Pre]

    if (buttonThatWasClicked == addToPatcherButton)
    {
        //[UserButtonCode_addToPatcherButton] -- add your button handler code here..

		sendChangeMessage();

        //[/UserButtonCode_addToPatcherButton]
    }

    //[UserbuttonClicked_Post]
    //[/UserbuttonClicked_Post]
}



//[MiscUserCode] You can add your own definitions of your custom methods or any other code here...

//------------------------------------------------------------------------------
void EXCOSCSettingsComponent::textEditorTextChanged(TextEditor& editor)
{
	sendChangeMessage();
}

//------------------------------------------------------------------------------
void EXCOSCSettingsComponent::setListenPort(const String& port)
{
	listenPortEditor->setText(port, false);
}

//------------------------------------------------------------------------------
void EXCOSCSettingsComponent::setSendAddress(const String& address)
{
	sendAddressEditor->setText(address, false);
}

//------------------------------------------------------------------------------
void EXCOSCSettingsComponent::setSendPort(const String& port)
{
	sendPortEditor->setText(port);
}

//------------------------------------------------------------------------------
void EXCOSCSettingsComponent::setAddPortsToPatcher(bool val)
{
	addToPatcherButton->setToggleState(val, false);
}

//[/MiscUserCode]


//==============================================================================
#if 0
/*  -- Introjucer information section --

    This is where the Introjucer stores the metadata that describe this GUI layout, so
    make changes in here at your peril!

BEGIN_JUCER_METADATA

<JUCER_COMPONENT documentType="Component" className="EXCOSCSettingsComponent"
                 componentName="" parentClasses="public Component, public ChangeBroadcaster, public TextEditor::Listener"
                 constructorParams="" variableInitialisers="" snapPixels="8" snapActive="1"
                 snapShown="1" overlayOpacity="0.330000013" fixedSize="0" initialWidth="600"
                 initialHeight="400">
  <BACKGROUND backgroundColour="ffeeece1"/>
  <LABEL name="listenPortLabel" id="7d3c95d8b5e89761" memberName="listenPortLabel"
         virtualName="" explicitFocusOrder="0" pos="8 8 88 24" edTextCol="ff000000"
         edBkgCol="0" labelText="Listen Port:" editableSingleClick="0"
         editableDoubleClick="0" focusDiscardsChanges="0" fontname="Default font"
         fontsize="15" bold="0" italic="0" justification="33"/>
  <TEXTEDITOR name="listenPortEditor" id="eca9c7828234df75" memberName="listenPortEditor"
              virtualName="" explicitFocusOrder="0" pos="96 8 56 24" initialText="5678"
              multiline="0" retKeyStartsLine="0" readonly="0" scrollbars="1"
              caret="1" popupmenu="1"/>
  <LABEL name="sendAddressLabel" id="1695405b521b1895" memberName="sendAddressLabel"
         virtualName="" explicitFocusOrder="0" pos="8 40 104 24" edTextCol="ff000000"
         edBkgCol="0" labelText="Send Address:" editableSingleClick="0"
         editableDoubleClick="0" focusDiscardsChanges="0" fontname="Default font"
         fontsize="15" bold="0" italic="0" justification="33"/>
  <TEXTEDITOR name="sendAddressEditor" id="3da5b72f6aeaa6ea" memberName="sendAddressEditor"
              virtualName="" explicitFocusOrder="0" pos="112 40 96 24" initialText="127.0.0.1"
              multiline="0" retKeyStartsLine="0" readonly="0" scrollbars="1"
              caret="1" popupmenu="1"/>
  <LABEL name="sendPortLabel" id="697d55ae5190cd29" memberName="sendPortLabel"
         virtualName="" explicitFocusOrder="0" pos="216 40 80 24" edTextCol="ff000000"
         edBkgCol="0" labelText="Send Port:" editableSingleClick="0" editableDoubleClick="0"
         focusDiscardsChanges="0" fontname="Default font" fontsize="15"
         bold="0" italic="0" justification="33"/>
  <TEXTEDITOR name="sendPortEditor" id="d9b7593b2ba149bd" memberName="sendPortEditor"
              virtualName="" explicitFocusOrder="0" pos="296 40 56 24" initialText="10001"
              multiline="0" retKeyStartsLine="0" readonly="0" scrollbars="1"
              caret="1" popupmenu="1"/>
  <TOGGLEBUTTON name="addToPatcherButton" id="a7aafc4054af7c70" memberName="addToPatcherButton"
                virtualName="" explicitFocusOrder="0" pos="167R 8 159 24" buttonText="Add ports to Patcher"
                connectedEdges="0" needsCallback="1" radioGroupId="0" state="0"/>
</JUCER_COMPONENT>

END_JUCER_METADATA
*/
#endif


//[EndFile] You can add extra defines here...
//[/EndFile]
